/**
 *
 * $Id: ManagerP.h,v 1.14 1996/04/09 08:56:35 u27113 Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_MANAGER_P_H
#define XM_MANAGER_P_H 

#include <Xm/XmP.h>

#ifdef __cplusplus
extern "C" {
#endif

/* structure used for storing accelerator and mnemonic information */
typedef struct {
    unsigned int eventType;
    KeySym	keysym;
    KeyCode	key;
    unsigned int modifiers;
    Widget	component;
    Boolean	needGrab;
    Boolean	isMnemonic;
    String	accelerator;	/* Added by Danny 4/4/96 */
} XmKeyboardData;

/* Define the manager instance part */
typedef struct {
    Pixel foreground;

    Dimension shadow_thickness;
    Pixel top_shadow_color;
    Pixmap top_shadow_pixmap;
    Pixel bottom_shadow_color;
    Pixmap bottom_shadow_pixmap;

    Pixel highlight_color;
    Pixmap highlight_pixmap;

    XtCallbackList help_callback;
    XtPointer user_data;

    Boolean traversal_on;
    unsigned char unit_type;
    XmNavigationType navigation_type;

    /* private instance variables */
    Boolean event_handler_added;
    Widget active_child; 
    Widget highlighted_widget;
    Widget accelerator_widget;

    Boolean has_focus;

    XmStringDirection string_direction;

    XmKeyboardData *keyboard_list;
    short num_keyboard_entries;
    short size_keyboard_list;

    XmGadget selected_gadget;
    XmGadget eligible_for_multi_button_event;

    GC background_GC;
    GC highlight_GC;
    GC top_shadow_GC;
    GC bottom_shadow_GC;

    Widget initial_focus;
} XmManagerPart;

typedef struct {
    XtPointer next_extension;
    XrmQuark record_type;
    long version;
    Cardinal record_size;
    XmTraversalChildrenProc traversal_children;
} XmManagerClassExtRec, *XmManagerClassExt;

#define XmManagerClassExtVersion 1L

/* Define the full instance record */
typedef struct _XmManagerRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    XmManagerPart manager;
} XmManagerRec;

/* Define class part structure */
typedef struct {
    String translations;
    XmSyntheticResource *syn_resources; 
    int num_syn_resources;
    XmSyntheticResource *syn_constraint_resources;
    int num_syn_constraint_resources;
    XmParentProcessProc parent_process;
    XtPointer extension;
} XmManagerClassPart;

#define XmInheritParentProcess ((XmParentProcessProc) _XtInherit)

/* Define the full class record */
typedef struct _XmManagerClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart manager_class;
} XmManagerClassRec;

/* manager constraints */

typedef struct _XmManagerConstraintPart {
    int unused;
} XmManagerConstraintPart;

typedef struct _XmManagerConstraintRec {
    XmManagerConstraintPart manager;
} XmManagerConstraintRec, *XmManagerConstraintPtr;

extern XmManagerClassRec xmManagerClassRec;

/*
 * easy access macros -- FOR USE BY GADGET CODE ONLY
 */
#define XmParentForeground(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.foreground)

#define XmParentBackground(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->core.background_pixel)

#define XmParentTopShadowGC(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.top_shadow_GC)

#define XmParentTopShadowColor(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.top_shadow_color)

#define XmParentBottomShadowGC(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.bottom_shadow_GC)

#define XmParentBottomShadowColor(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.bottom_shadow_color)

#define XmParentHighlightColor(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.highlight_color)

#define XmParentHighlightGC(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.highlight_GC)

#define XmParentBackgroundGC(w) (((XmManagerWidget) \
        (((XmGadget)(w))->object.parent))->manager.background_GC)

/*
 * easy access macros -- FOR USE BY MANAGERS.
 */

#define MGR_InitialFocus(w) \
        (((XmManagerWidget)(w))->manager.initial_focus)
    
#define MGR_KeyboardList(m) \
	(((XmManagerWidget)(m))->manager.keyboard_list)

#define MGR_NumKeyboardEntries(m) \
	(((XmManagerWidget)(m))->manager.num_keyboard_entries)

#define MGR_SizeKeyboardList(m) \
	(((XmManagerWidget)(m))->manager.size_keyboard_list)

#define MGR_ShadowThickness(m) \
	(((XmManagerWidget)(m))->manager.shadow_thickness)

#define MGR_BackgroundGC(m) \
	(((XmManagerWidget)(m))->manager.background_GC)

#define MGR_Foreground(m) \
	(((XmManagerWidget)(m))->manager.foreground)

#define MGR_TopShadowGC(m) \
	(((XmManagerWidget)(m))->manager.top_shadow_GC)

#define MGR_TopShadowColor(m) \
	(((XmManagerWidget)(m))->manager.top_shadow_color)

#define MGR_TopShadowPixmap(m) \
	(((XmManagerWidget)(m))->manager.top_shadow_pixmap)

#define MGR_BottomShadowGC(m) \
	(((XmManagerWidget)(m))->manager.bottom_shadow_GC)

#define MGR_BottomShadowColor(m) \
	(((XmManagerWidget)(m))->manager.bottom_shadow_color)

#define MGR_BottomShadowPixmap(m) \
	(((XmManagerWidget)(m))->manager.bottom_shadow_pixmap)

#define MGR_HighlightGC(m) \
	(((XmManagerWidget)(m))->manager.highlight_GC)

#define MGR_HighlightColor(m) \
	(((XmManagerWidget)(m))->manager.highlight_color)

#define MGR_HighlightPixmap(m) \
	(((XmManagerWidget)(m))->manager.highlight_pixmap)

#define MGR_HelpCallbackList(m) \
	(((XmManagerWidget)(m))->manager.help_callback)

#define MGR_EventHandlerAdded(m) \
	(((XmManagerWidget)(m))->manager.event_handler_added)

#define MGR_HighlightedWidget(m) \
	(((XmManagerWidget)(m))->manager.highlighted_widget)

#define MGR_ActiveChild(m) \
	(((XmManagerWidget)(m))->manager.active_child)

#define MGR_SelectedGadget(m) \
	(((XmManagerWidget)(m))->manager.selected_gadget)

#define MGR_NavigationType(m) \
	(((XmManagerWidget)(m))->manager.navigation_type)

#define MGR_TraversalOn(m) \
	(((XmManagerWidget)(m))->manager.traversal_on)

#define MGR_UnitType(m) \
	(((XmManagerWidget)(m))->manager.unit_type)

/* a couple of #defines to make composite stuff easier */

#define MGR_NumChildren(m) \
	(((XmManagerWidget)(m))->composite.num_children)

#define MGR_Children(m) \
	(((XmManagerWidget)(m))->composite.children)
	 
/* internal manager routines */

Boolean _XmParentProcess(Widget widget, XmParentProcessData data);
void _XmDestroyParentCallback ( Widget w, XtPointer client, XtPointer call );
/* What the F is this? */
void _XmSocorro(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmClearShadowType(Widget w,
			Dimension old_width, Dimension old_height,
			Dimension old_shadow_thickness,
			Dimension old_highlight_thickness);

/* action routine prototypes */
void _XmGadgetButtonMotion(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetArm(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetMultiArm(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetMultiActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetDrag(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetSelect(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmParentActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmParentCancel(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraversePrevTabGroup(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseNextTabGroup(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraversePrev(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseNext(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseDown(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseLeft(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseRight(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetTraverseHome(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetHelp(Widget w, XEvent *event, String *params, Cardinal *num_params);
void _XmGadgetKeyInput(Widget w, XEvent *event, String *params, Cardinal *num_params);

#ifdef __cplusplus
};
#endif

#endif /* XM_MANAGER_P_H */
