/* Private Library Header
 */

#include <powerup/gcclib/powerup_protos.h>
#include <powerup/ppclib/tasks.h>
#include <setjmp.h>
#include <exec/ports.h>
#include <exec/interrupts.h>
#include <workbench/startup.h>

#include <user.h>

#define MAX_ARG 20

#define PARSE_ELLIPSE(str,elist,ap) { \
	int anz=0,mode=0; \
	unsigned int floatarray[2]; \
	double floatstore; \
	for(; (*##str)!=NULL;##str++) \
	{ \
		if( mode == 1) \
		{ \
			if( ((*##str)=='f') || ((*##str)=='e') || ((*##str)=='E')|| ((*##str)=='g')|| ((*##str)=='G') ) \
			{ \
				floatstore=(double)va_arg(##ap,double); \
				(void)memcpy(&floatarray[0],&floatstore,8); \
				##elist[anz++]=floatarray[0]; \
				##elist[anz++]=floatarray[1]; \
				mode=0; \
			} \
			else if( (((*##str)>='0') && ((*##str)<='9')) || ((*##str)=='.')  ) \
			{ \
			} \
			else if( (*##str)=='*' ) \
			{ \
				##elist[anz++]=va_arg(##ap,int); \
			} \
			else \
			{ \
				##elist[anz++]=va_arg(##ap,int); \
				mode=0; \
			} \
		} \
		if( (*##str)=='%') \
		{ \
			mode=1; \
		} \
	} \
}

struct __exitfuncs {
    struct __exitfuncs *next;
    void (*func)(void);
};

struct ix_user {
	unsigned short		*m68k;
	struct ixemul_base	*ibase;
	struct user		*u_ptr;
	jmp_buf			jmpbuf; /* check float alignment! */
	int			ret_val;
	struct	__sFILE		**sF;
	int			ix_expand_cmd_line;
	int			*errno;
	void			*first_mlist;
	struct WBStartup	*wb_msg;
	struct __exitfuncs	*firstexit;
	unsigned int		null;
};


//#define errno (* u.u_errno)
