#ifndef VNC_REQUESTER_H
#define VNC_REQUESTER_H
/*********************************************************
 ** ViNCEd                                              **
 ** a DOS - window handler                              **
 **                                                     **
 **  1991-98 THOR-Software inc.                        **
 ** Version 3.60                                        **
 **                                                     **
 ** program version 3.60 22 Aug 98      THOR            **
 **                                                     **
 ** ViNCEd Standard Requesters                          **
 **-----------------------------------------------------**
 **                                                     **
 ** all use at your own risk,etc.,etc.                  **
 **                                                     **
 ** Everything declared as "reserved" or                **
 ** "not used" is NOT free for your use,                **
 ** it will propably used in a later release.           **
 ** All FREE entries are free for public                **
 ** use and are, if not otherwise noticed,              **
 ** initialized as ZERO                                 **
 *********************************************************/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef INTUITION_INTUTION_H
#include <intuition/intuition.h>
#endif

/* This is a standard file requester. Either arp or asl (or reqtools)
   requesters are used to display them. This works in all OS revisions. */

struct ViRequest {
        char            *vreq_Hail;     /* title string */
        char            *vreq_File;     /* file name */
        char            *vreq_Dir;      /* directory name */
        struct Window   *vreq_Window;   /* window to lock */
        UWORD            vreq_Flags;    /* flags, see below */
        ULONG            vreq_reserved; /* must be zero */
        char            *vreq_Pattern;  /* pattern matching string */

        WORD             vreq_LeftEdge; /* requested positions */
        WORD             vreq_TopEdge;

        UWORD            vreq_Width;    /* requested size */
        UWORD            vreq_Height;
};


/* Split file name in file and directory, fill in dir automatically */
#define VREQ_AUTOSPLIT_BIT      0
#define VREQ_AUTOSPLIT_MASK     (1L<<0)

/* Split file in dir and pattern, clear file */
#define VREQ_AUTOPAT_BIT        1
#define VREQ_AUTOPAT_MASK       (1L<<1)

/* Join file and dir after requesting */
#define VREQ_AUTOJOIN_BIT       2
#define VREQ_AUTOJOIN_MASK      (1L<<2)

/* Requester dimensions are valid. This bit must be set or
   the vreq_LeftEdge to vreq_Height fields are ignored. Strictly
   for backwards compatibility */
#define VREQ_DIMENSIONS_BIT     8
#define VREQ_DIMENSIONS_MASK    (1L<<8)

#endif

