/*	$NetBSD: menus.md.fr,v 1.20 1999/06/20 06:08:19 cgd Exp $	*/

/*
 * Copyright 1997 Piermont Information Systems Inc.
 * All rights reserved.
 *
 * Written by Philip A. Nelson for Piermont Information Systems Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed for the NetBSD Project by
 *      Piermont Information Systems Inc.
 * 4. The name of Piermont Information Systems Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PIERMONT INFORMATION SYSTEMS INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL PIERMONT INFORMATION SYSTEMS INC. BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* Menu definitions for sysinst. i386 version, machine dependent. */

menu fullpart, y=15, title  "Faite votre choix";
	option "Utilisation d'une partie du disque", exit, action  {usefull = 0;};
	option "Utilisation de tout le disque", 	    exit, action  {usefull = 1;};

menu wdtype, title  "Choix du type de disque";
	display action { msg_display (MSG_wdtype, diskdev); };
	option "IDE", 	exit;
	option "ESDI", 	exit, action
		{ msg_display (MSG_sectforward);
		  process_menu (MENU_yesno);
		  if (yesno)
			doessf = "sf:";
		};
	option "ST506", exit, action
		{ msg_display (MSG_sectforward);
		  process_menu (MENU_yesno);
		  if (yesno)
			doessf = "sf:";
		};


menu dlgeom, title "Choisissez une option";
	display action { msg_display (MSG_dlgeom, diskdev, dlcyl, dlhead,
				dlsec, disk->dd_cyl, disk->dd_head,
				disk->dd_sec);
			};
	option "Utilisation de la gomtrie relle", exit, action {
			dlcyl  = disk->dd_cyl;
			dlhead = disk->dd_head;
			dlsec  = disk->dd_sec;
		};
	option "Utilisation de la gomtrie du disklabel", exit, action {
			disk->dd_cyl = dlcyl;
			disk->dd_head = dlhead;
			disk->dd_sec = dlsec;
		};


menu editparttable, title  "Choisissez votre partition", exit;
	display action  { msg_display (MSG_editparttable);
			  disp_cur_part((struct mbr_partition *)&mbr[MBR_PARTOFF
], activepart,-1);
			};
	option "Edition de la partition 0",  sub menu editpart,
		action  { editpart = 0; };
	option "Edition de la partition 1",  sub menu editpart,
		action  { editpart = 1; };
	option "Edition de la partition 2",  sub menu editpart,
		action  { editpart = 2; };
	option "Edition de la partition 3",  sub menu editpart,
		action  { editpart = 3; };
	option "Changer d'untit",
		action  { reask_sizemult(); };

menu editpart, title  "Changement";
	display action { msg_display (MSG_editpart, editpart);
			   disp_cur_part((struct mbr_partition *)&mbr[MBR_PARTOFF
], activepart,editpart);
			   msg_printf_add ("\n");
			};
	option "du type de FS", sub menu chooseid;
	option "du Dbut et de la taille", action 
		{	char buf[40]; int start, size;
			msg_prompt_add (MSG_start, NULL, buf, 40);
			start = NUMSEC(atoi(buf),sizemult,dlcylsize);
			if (sizemult > 1 && start < bsec)
				start = bsec;
			msg_prompt_add (MSG_size, NULL, buf, 40);
			size = NUMSEC(atoi(buf),sizemult,dlcylsize);
			if (sizemult > 1 && start == bsec)
				size -= bsec;
			if (start + size > bsize)
				size = bsize - start;
			if (size < 0) {
				size = 0;
				start = 0;
			}
			part[editpart].mbrp_start = start;
			part[editpart].mbrp_size = size;
		};
	option "Rendre la partition active", action { activepart = editpart; };
	option "Partition OK", exit;

		msg_display(MSG_cyl1024);
	};
	option "Rditer le secteur de boot et le label", exit, action
	{
		/* XXX UGH */
		extern int c1024_resp;

		c1024_resp = 1;
	};
    option "Rditer le label", exit, action
	{
		extern int c1024_resp;

		c1024_resp = 2;
	};
	option "L'utiliser tout de mme", exit, action
	{
		extern int c1024_resp;

		c1024_resp = 3;
	};

menu editfsparts, y=13, exit;
	display action  {
			ask_sizemult();
			msg_display(MSG_fspart, multname);
			disp_cur_fspart(-1, 1);
		};
	option "Changer a", action { editpart = A;}, sub menu edfspart;
	option "Changer b", action { editpart = B;}, sub menu edfspart;
	option "Partition de NetBSD - Changement impossible", action {};
	option "Totalit du disque - Changement impossible", action {};
	option "Changer e", action { editpart = E;}, sub menu edfspart;
	option "Changer f", action { editpart = F;}, sub menu edfspart;
	option "Changer g", action { editpart = G;}, sub menu edfspart;
	option "Changer h", action { editpart = H;}, sub menu edfspart;
	option "Changer d'unit", action { reask_sizemult(); };
 

menu md_distcustom, y=3, exit, title "Slection des composants";
	display action { show_cur_distsets (); };
	option  "Outils de dveloppement ", 	 action { toggle_getit (3); };
	option  "Jeux", 		 action { toggle_getit (4); };
	option  "Pages de manuel", 	 action { toggle_getit (5); };
	option  "Divers", 	 action { toggle_getit (6); };
	option  "Outils de manipulation de textes", action { toggle_getit (7); };
	option  "X11 base et clients",	 action { toggle_getit (8); };
	option  "X11 polices",		 action { toggle_getit (9); };
	option  "X11 serveurs",		 action { toggle_getit (10); };
	option  "X11 clients contribus",	 action { toggle_getit (11); };
	option  "X11 dveloppement",	 action { toggle_getit (12); };
